<?php
    require_once('source/session.php');
    require_once('source/error.php');
    require_once('source/dbconfig.php');
    require_once('source/function.php');
    require_once('source/restrict_admin.php');
    session_start();    
    
    // Check if the user is logged in 
    if (isset($_SESSION['SESS_ID_ADMIN'])) {
        $userId = $_SESSION['SESS_ID_ADMIN'];

        // Fetch user details based on the ID
        $query = "SELECT * FROM tbl_admin WHERE id = :id";
        $stmt = $DBH->prepare($query);
        $stmt->bindParam(':id', $userId, PDO::PARAM_INT);
        $stmt->execute();

        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $adminName = $row['username'];
        }
    }
    
    if(isset($_GET['msg']) && $_GET['msg'] == "refered"){
        $msg = "<div class='alert alert-success mb-3'>Refered successfully</div>";
    } else if(isset($_GET['msg']) && $_GET['msg'] == "failed"){
        $msg = "<div class='alert alert-warning mb-3'>Something went wrong, please try again</div>";
    }
    
    if(isset($_SESSION['msg']) && $_SESSION['msg'] == "update") {
        $msg = "<div class='alert alert-success text-center mb-3'>Order Update Succesful. Customer will receive email.<a 
        class='btn-sm' href='new_order.php'>Refresh</a></div>";
    }       
    
    // Count students (teacher = false)
    $studentCount = $DBH->query("SELECT COUNT(*) FROM tbl_user WHERE teacher = 'false'")->fetchColumn();
    // Count teachers (teacher = true)
    $teacherCount = $DBH->query("SELECT COUNT(*) FROM tbl_user WHERE teacher = 'true'")->fetchColumn();
    // Count results based on unique admission number per term per session
    $resultCount = $DBH->query("SELECT COUNT(DISTINCT CONCAT(registration_no, '-', term, '-', year)) FROM tbl_student_results")->fetchColumn();
    // Count active sessions from tbl_session
    $sessionCount = $DBH->query("SELECT COUNT(DISTINCT session) FROM tbl_session")->fetchColumn();
    // Count admins
    $adminCount = $DBH->query("SELECT COUNT(*) FROM tbl_admin")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>VERBUM DEI INT'L COLLEGE - Admin Dashboard</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts - Nunito -->
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-color: #1976d2;
      --secondary-color: #64b5f6;
      --accent-color: #bbdefb;
      --dark-color: #0d47a1;
      --light-color: #e3f2fd;
      --text-dark: #212529;
      --text-light: #f8f9fa;
      
      /* Group colors - Updated with more vibrant options */
      --group-1: #4caf50;
      --group-1-light: #e8f5e9;
      --group-2: #2196f3;
      --group-2-light: #e3f2fd;
      --group-3: #9c27b0;
      --group-3-light: #f3e5f5;
      --group-4: #ff9800;
      --group-4-light: #fff3e0;
      --group-5: #f44336;
      --group-5-light: #ffebee;
      --group-6: #607d8b;
      --group-6-light: #eceff1;
      --group-7: #009688;
      --group-7-light: #e0f2f1;
      --group-8: #673ab7;
      --group-8-light: #ede7f6;
      --group-9: #795548;
      --group-9-light: #efebe9;
      
      /* Stat card colors */
      --stat-1: #4caf50;
      --stat-2: #2196f3;
      --stat-3: #9c27b0;
      --stat-4: #ff9800;
      --stat-5: #f44336;
    }
    
    body {
      font-family: 'Nunito', sans-serif;
      background-color: #f5f7fa;
      padding-top: 56px;
      color: var(--text-dark);
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-color) 0%, var(--primary-color) 100%);
      position: fixed;
      top: 56px;
      left: 0;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
     
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--secondary-color);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 250px;
      width: calc(100% - 250px);
      transition: all 0.3s;
      min-height: calc(100vh - 56px);
      padding-bottom: 60px;
    }
    
    @media (max-width: 991.98px) {
      .sidebar {
        left: -250px;
      }
      .main-content {
        margin-left: 0;
        width: 100%;
      }
      body {
        padding-top: 56px;
      }
    }
    
    /* Compact layout */
    .dashboard-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 1rem;
      padding: 1rem;
    }
    
    .group-card {
      border-radius: 0.5rem;
      box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
      overflow: hidden;
      height: 100%;
      display: flex;
      flex-direction: column;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .group-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.15);
    }
    
    .group-header {
      padding: 0.75rem 1rem;
      color: white;
      font-weight: 600;
      display: flex;
      align-items: center;
      font-size: 0.95rem;
    }
    
    .group-header i {
      margin-right: 0.5rem;
      font-size: 1rem;
      color: white;
    }
    
    .group-body {
      padding: 0.75rem;
      background: white;
      flex-grow: 1;
      display: grid;
      grid-template-columns: 1fr;
      gap: 0.5rem;
    }
    
    .group-item {
      display: flex;
      align-items: center;
      padding: 0.5rem;
      border-radius: 0.25rem;
      transition: all 0.2s;
      color: var(--text-dark);
      text-decoration: none;
      font-size: 0.85rem;
    }
    
    /* Alternating background colors for group items */
    .group-card:nth-child(1) .group-item:nth-child(odd) { background-color: var(--group-1-light); }
    .group-card:nth-child(2) .group-item:nth-child(odd) { background-color: var(--group-2-light); }
    .group-card:nth-child(3) .group-item:nth-child(odd) { background-color: var(--group-3-light); }
    .group-card:nth-child(4) .group-item:nth-child(odd) { background-color: var(--group-4-light); }
    .group-card:nth-child(5) .group-item:nth-child(odd) { background-color: var(--group-5-light); }
    .group-card:nth-child(6) .group-item:nth-child(odd) { background-color: var(--group-6-light); }
    .group-card:nth-child(7) .group-item:nth-child(odd) { background-color: var(--group-7-light); }
    .group-card:nth-child(8) .group-item:nth-child(odd) { background-color: var(--group-8-light); }
    .group-card:nth-child(9) .group-item:nth-child(odd) { background-color: var(--group-9-light); }
    
    .group-item:hover {
      background-color: rgba(0,0,0,0.05) !important;
      transform: translateX(3px);
    }
    
    .group-item i {
      width: 20px;
      text-align: center;
      margin-right: 0.5rem;
      color: inherit;
      font-size: 0.9rem;
    }
    
    /* Navbar */
    .navbar {
      background-color: var(--primary-color);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    /* Welcome banner */
    .welcome-banner {
      background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
      color: white;
      border-radius: 0.5rem;
      padding: 1rem;
      margin: 1rem;
      box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    
    /* Stats cards - Updated with colorful design */
    .stats-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
      gap: 1rem;
      margin: 0 1rem 1rem;
    }
    
    .stat-card {
      border-radius: 0.5rem;
      padding: 1rem;
      text-align: center;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      color: white;
      transition: transform 0.3s ease;
    }
    
    .stat-card:hover {
      transform: translateY(-3px);
    }
    
    .stat-card i {
      font-size: 1.5rem;
      margin-bottom: 0.5rem;
      color: white;
      background-color: rgba(255,255,255,0.2);
      width: 50px;
      height: 50px;
      line-height: 50px;
      border-radius: 50%;
      display: inline-block;
    }
    
    .stat-card h5 {
      font-size: 1.5rem;
      margin-bottom: 0.25rem;
      font-weight: 700;
    }
    
    .stat-card p {
      font-size: 0.9rem;
      margin-bottom: 0;
      opacity: 0.9;
    }
    
    /* Color assignments for stat cards */
    .stat-card:nth-child(1) { background: linear-gradient(135deg, var(--stat-1) 0%, #66bb6a 100%); }
    .stat-card:nth-child(2) { background: linear-gradient(135deg, var(--stat-2) 0%, #64b5f6 100%); }
    .stat-card:nth-child(3) { background: linear-gradient(135deg, var(--stat-3) 0%, #ba68c8 100%); }
    .stat-card:nth-child(4) { background: linear-gradient(135deg, var(--stat-4) 0%, #ffb74d 100%); }
    .stat-card:nth-child(5) { background: linear-gradient(135deg, var(--stat-5) 0%, #ef5350 100%); }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-color);
      color: white;
      padding: 15px 0;
      position: fixed;
      bottom: 0;
      width: 100%;
      z-index: 100;
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 0.85rem;
    }
    
    .powered-by {
      display: flex;
      align-items: center;
      justify-content: flex-end;
      color: white;
      font-size: 0.85rem;
    }
    
    .powered-by img {
      height: 20px;
      margin-left: 8px;
    }
    
    .powered-by-link {
      display: flex;
      align-items: center;
      text-decoration: none;
      color: inherit;
      transition: opacity 0.3s ease;
    }
    
    .powered-by-link:hover {
      opacity: 0.8;
      text-decoration: none;
    }
    
    /* Group header colors */
    .group-header.group-1 { background: linear-gradient(135deg, var(--group-1) 0%, #66bb6a 100%); }
    .group-header.group-2 { background: linear-gradient(135deg, var(--group-2) 0%, #64b5f6 100%); }
    .group-header.group-3 { background: linear-gradient(135deg, var(--group-3) 0%, #ba68c8 100%); }
    .group-header.group-4 { background: linear-gradient(135deg, var(--group-4) 0%, #ffb74d 100%); }
    .group-header.group-5 { background: linear-gradient(135deg, var(--group-5) 0%, #ef5350 100%); }
    .group-header.group-6 { background: linear-gradient(135deg, var(--group-6) 0%, #90a4ae 100%); }
    .group-header.group-7 { background: linear-gradient(135deg, var(--group-7) 0%, #4db6ac 100%); }
    .group-header.group-8 { background: linear-gradient(135deg, var(--group-8) 0%, #9575cd 100%); }
    .group-header.group-9 { background: linear-gradient(135deg, var(--group-9) 0%, #a1887f 100%); }
    
    /* Card icons color */
    .group-card:nth-child(1) .group-item i { color: var(--group-1); }
    .group-card:nth-child(2) .group-item i { color: var(--group-2); }
    .group-card:nth-child(3) .group-item i { color: var(--group-3); }
    .group-card:nth-child(4) .group-item i { color: var(--group-4); }
    .group-card:nth-child(5) .group-item i { color: var(--group-5); }
    .group-card:nth-child(6) .group-item i { color: var(--group-6); }
    .group-card:nth-child(7) .group-item i { color: var(--group-7); }
    .group-card:nth-child(8) .group-item i { color: var(--group-8); }
    .group-card:nth-child(9) .group-item i { color: var(--group-9); }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-light">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($adminName ?? 'Admin'); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i> Logout
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link active" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Dashboard
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Create Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers & Admins
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="upload_results.php">
            <i class="fas fa-fw fa-upload"></i>
            Upload Results
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <!-- Welcome Banner -->
    <div class="welcome-banner">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <h4>Welcome back, <?php echo htmlspecialchars($adminName ?? 'Admin'); ?>!</h4>
          <p class="mb-0">Verbum Dei Int'l College Admin Dashboard</p>
        </div>
        <div class="d-none d-sm-inline-block">
          <span class="badge bg-white text-primary p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: MENDOH - 08032929756
          </span>
        </div>
      </div>
    </div>

    <?php if(isset($msg)) { echo $msg; } ?>

    <!-- Quick Stats Section - Updated with colorful cards -->
    <div class="stats-container">
      <div class="stat-card">
        <i class="fas fa-users"></i>
        <h5><?php echo number_format($studentCount); ?></h5>
        <p>Total Students</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-chalkboard-teacher"></i>
        <h5><?php echo number_format($teacherCount); ?></h5>
        <p>Total Teachers</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-user-shield"></i>
        <h5><?php echo number_format($adminCount); ?></h5>
        <p>Total Admins</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-poll"></i>
        <h5><?php echo number_format($resultCount); ?></h5>
        <p>Result Records</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-calendar-alt"></i>
        <h5><?php echo number_format($sessionCount); ?></h5>
        <p>Academic Sessions</p>
      </div>
    </div>

    <!-- Dashboard Groups -->
    <div class="dashboard-container">
      <!-- 1. Manage Learners -->
      <div class="group-card">
        <div class="group-header group-1">
          <i class="fas fa-users"></i>
          <span>Manage Learners</span>
        </div>
        <div class="group-body">
          <a href="add_students.php" class="group-item">
            <i class="fas fa-user-plus"></i>
            <span>Register New Student</span>
          </a>
          <a href="students.php" class="group-item">
            <i class="fas fa-users"></i>
            <span>Manage Students</span>
          </a>
          <a href="deactivate_students.php" class="group-item">
            <i class="fas fa-user-lock"></i>
            <span>Activate/Deactivate</span>
          </a>
        </div>
      </div>

      <!-- 2. Manage Teachers & Admins -->
      <div class="group-card">
        <div class="group-header group-2">
          <i class="fas fa-chalkboard-teacher"></i>
          <span>Manage Teachers & Admins</span>
        </div>
        <div class="group-body">
          <a href="teachers.php?action=add" class="group-item">
            <i class="fas fa-user-plus"></i>
            <span>Register New Teacher</span>
          </a>
          <a href="teachers.php" class="group-item">
            <i class="fas fa-user-tie"></i>
            <span>Manage Teachers</span>
          </a>
          <a href="list_admin.php" class="group-item">
            <i class="fas fa-user-shield"></i>
            <span>Manage Admins</span>
          </a>
          <a href="lesson_plan/lesson_plan_list.php" class="group-item">
            <i class="fas fa-tasks"></i>
            <span>Lesson Plans</span>
          </a>
        </div>
      </div>

      <!-- 3. Manage Results -->
      <div class="group-card">
        <div class="group-header group-3">
          <i class="fas fa-poll"></i>
          <span>Manage Results</span>
        </div>
        <div class="group-body">
          <a href="upload_results.php" class="group-item">
            <i class="fas fa-file-csv"></i>
            <span>Upload Results</span>
          </a>
          <a href="post_attendance.php" class="group-item">
            <i class="fas fa-file-csv"></i>
            <span style="color:blue">Upload Attendance & Comments</span>
          </a>
          <a href="post_skills.php" class="group-item">
            <i class="fas fa-file-csv"></i>
            <span style="color:green">Upload Psychomotor Skills</span>
          </a>
          <a href="uploaded_class_results.php" class="group-item">
            <i class="fas fa-edit"></i>
            <span>Update Scores</span>
          </a>
          <a href="download_broadsheet.php" class="group-item">
            <i class="fas fa-file-pdf"></i>
            <span>View/Print Broadsheet</span>
          </a>
          <a href="list_comments.php" class="group-item">
            <i class="fas fa-comments"></i>
            <span>Modify Comments</span>
          </a>
        </div>
      </div>

      <!-- 4. Manage CBT -->
      <div class="group-card">
        <div class="group-header group-4">
          <i class="fas fa-laptop-code"></i>
          <span>Manage CBT</span>
        </div>
        <div class="group-body">
          <a href="cbt/cbt_admin_home.php" class="group-item">
            <i class="fas fa-laptop"></i>
            <span>Manage CBT</span>
          </a>
            <a href="https://cbt.vda.com.ng/entrance/login.php" class="group-item" target="_blank" rel="noopener noreferrer">
                <i class="fas fa-laptop"></i>
                <span style="color:blue">Manage ENTRANCE CBT</span>
            </a>
          <a href="cbt/generate_access_key.php" class="group-item">
            <i class="fas fa-key"></i>
            <span>Generate Access Code</span>
          </a>
        </div>
      </div>

      <!-- 5. Manage Complaints -->
      <div class="group-card">
        <div class="group-header group-5">
          <i class="fas fa-exclamation-circle"></i>
          <span>Manage Complaints</span>
        </div>
        <div class="group-body">
          <a href="complaint_admin.php" class="group-item">
            <i class="fas fa-comment-dots"></i>
            <span>Manage Complaints</span>
          </a>
        </div>
      </div>

      <!-- 6. Manage PINs -->
      <div class="group-card">
        <div class="group-header group-6">
          <i class="fas fa-key"></i>
          <span>Manage PINs</span>
        </div>
        <div class="group-body">
          <a href="find_pin_user.php" class="group-item">
            <i class="fas fa-search"></i>
            <span>Confirm PIN User</span>
          </a>
        </div>
      </div>

      <!-- 7. Academic Analysis -->
      <div class="group-card">
        <div class="group-header group-7">
          <i class="fas fa-chart-bar"></i>
          <span>Academic Analysis</span>
        </div>
        <div class="group-body">
          <a href="result_analysis.php" class="group-item">
            <i class="fas fa-chart-line"></i>
            <span>Result Analysis</span>
          </a>
          <a href="#" class="group-item">
            <i class="fas fa-trophy"></i>
            <span>Top Performers</span>
          </a>
          <a href="#" class="group-item">
            <i class="fas fa-chart-pie"></i>
            <span>Subject Analysis</span>
          </a>
        </div>
      </div>

      <!-- 8. Assignments -->
      <div class="group-card">
        <div class="group-header group-8">
          <i class="fas fa-tasks"></i>
          <span>Assignments</span>
        </div>
        <div class="group-body">
          <a href="assignments.php" class="group-item">
            <i class="fas fa-book-open"></i>
            <span>Manage Assignments</span>
          </a>
        </div>
      </div>

      <!-- 9. Other Modules -->
      <div class="group-card">
        <div class="group-header group-9">
          <i class="fas fa-cubes"></i>
          <span>Other Modules</span>
        </div>
        <div class="group-body">
          <a href="post_session.php" class="group-item">
            <i class="fas fa-calendar-plus"></i>
            <span>Academic Year</span>
          </a>
          <a href="post_classes.php" class="group-item">
            <i class="fas fa-building"></i>
            <span>Classes</span>
          </a>
          <a href="post_subjects.php" class="group-item">
            <i class="fas fa-book"></i>
            <span>Subjects</span>
          </a>
          <a href="timetable.php" class="group-item">
            <i class="fas fa-calendar-alt"></i>
            <span>Time-Table</span>
          </a>
        </div>
      </div>
    </div>

    <!-- Uploaded Results Section -->
    <div class="card m-3">
      <div class="card-header bg-primary text-white">
        <h6 class="mb-0"><i class="fas fa-calendar-alt me-2"></i>Uploaded Results by Session</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <?php
          $STH = $DBH->prepare("SELECT count(*) FROM tbl_student_results WHERE id >= ?");
          $result = $STH->execute(array(1));
          $count = $STH->fetchColumn();
          
          if($count >= 1) {
            $rows = sql($DBH, "SELECT MIN(id) AS id, year FROM tbl_student_results WHERE id >= ? GROUP BY year", 
            array(1), "rows");
            foreach($rows as $row) {  
              $t_year = $row['year'];
              echo '
              <div class="col-md-3 mb-3">
                <a href="main_term.php?id='.$t_year.'" target="_blank" class="btn btn-outline-primary w-100">
                  <i class="fas fa-calendar-alt me-1"></i> '.$t_year.'
                </a>
              </div>';
            }
          } else {
            echo '<div class="col-12 text-center py-4">
              <i class="fas fa-info-circle fa-2x mb-3 text-muted"></i>
              <p class="text-muted">No academic records found yet</p>
            </div>';
          }
          ?>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="powered-by">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="powered-by-link">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
      document.getElementById('sidebar').classList.toggle('active');
      document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
      const sidebar = document.getElementById('sidebar');
      const sidebarToggle = document.getElementById('sidebarToggle');
      
      if (window.innerWidth < 992 && 
          !sidebar.contains(event.target) && 
          !sidebarToggle.contains(event.target) && 
          sidebar.classList.contains('active')) {
        sidebar.classList.remove('active');
        document.querySelector('.main-content').classList.remove('active');
      }
    });
  </script>
</body>
</html>